# Changelog - Protor Exam System Updates

## Version 2.1 - December 10, 2025

### New Features

#### 1. Edit Exam Functionality
- **File**: `admin/edit_exam.php` (NEW)
- **Description**: Added missing edit exam page that was referenced in `admin/exams.php` but didn't exist
- **Features**:
  - Edit exam title, description, duration, total questions
  - Change target grade and exam mode
  - Toggle active status
  - Toggle shuffle questions setting
  - Proper validation and error handling
  - Cancel button to return to exams list

#### 2. Question Shuffling
- **Files Modified**: 
  - `admin/create_exam.php`
  - `admin/edit_exam.php`
  - `student/take_exam.php`
  - Database schema (new column)
- **Description**: Added ability to randomly shuffle questions during exam
- **How it works**:
  - Admin can enable "Shuffle Questions" checkbox when creating/editing exams
  - When enabled, system randomly selects questions from the question bank
  - Number of questions selected equals the `total_questions` value set for the exam
  - Uses MySQL `ORDER BY RAND()` for random selection
  - Each student gets a random subset of questions (if shuffle is enabled)
- **Database Changes**:
  - Added `shuffle_questions` column to `exams` table (TINYINT, default 0)
  - Migration file: `migration_add_shuffle_questions.sql`

#### 3. Question Count Enforcement
- **File Modified**: `student/take_exam.php`
- **Description**: Fixed issue where all questions in database were shown regardless of exam's `total_questions` setting
- **Previous Behavior**: If exam had 10 questions in database but `total_questions` was set to 3, all 10 would display
- **New Behavior**: Only the exact number specified in `total_questions` field is displayed
- **Implementation**: Added SQL `LIMIT` clause based on exam's `total_questions` value

### Bug Fixes

#### 4. Time Tracking Correction
- **File Modified**: `admin/test_takers.php`
- **Description**: Fixed incorrect time spent calculation
- **Previous Issue**: Used DateTime object diff which had calculation errors
- **Solution**: 
  - Switched to Unix timestamp-based calculation using `strtotime()`
  - Calculate difference in seconds: `end_time - start_time`
  - Convert to hours, minutes, seconds format
  - Added validation for invalid time ranges
  - Returns 'N/A' for missing data, 'Invalid' for negative time differences

#### 5. Scoring System Fix
- **File Modified**: `admin/test_takers.php`
- **Description**: Fixed score display to use actual points allocated to questions
- **Previous Issue**: Score was compared against `duration_minutes` instead of total possible points
- **Solution**:
  - Calculate total possible score by summing `points` field from all answered questions
  - Query: `SELECT SUM(Q.points) FROM student_answers SA JOIN exam_questions Q...`
  - Display format: `score_earned / total_possible` (e.g., "7.00 / 9.00")
  - Respects individual question point values set by admin

### Technical Details

#### Database Schema Changes
```sql
ALTER TABLE exams 
ADD COLUMN shuffle_questions TINYINT(1) DEFAULT 0 
COMMENT 'Enable random question selection (1=Yes, 0=No)' 
AFTER is_active;
```

#### Files Created
1. `admin/edit_exam.php` - Edit exam functionality
2. `migration_add_shuffle_questions.sql` - Database migration script
3. `CHANGELOG.md` - This file

#### Files Modified
1. `admin/create_exam.php` - Added shuffle checkbox and database column creation
2. `admin/test_takers.php` - Fixed time calculation and scoring display
3. `student/take_exam.php` - Added question limit and shuffle support

### Installation Instructions

#### For New Installations
The system will automatically create the `shuffle_questions` column when creating or editing an exam.

#### For Existing Installations
Run the migration SQL file:
```bash
mysql -u root -p proctored_exam_app2 < migration_add_shuffle_questions.sql
```

Or execute manually in phpMyAdmin/MySQL client:
```sql
ALTER TABLE exams 
ADD COLUMN shuffle_questions TINYINT(1) DEFAULT 0 
AFTER is_active;
```

### Upgrade Notes

#### Backward Compatibility
- ✅ Fully backward compatible with existing exams
- ✅ Existing exams will have `shuffle_questions = 0` (disabled) by default
- ✅ No data migration required for existing exam sessions
- ✅ All existing functionality remains unchanged

#### Testing Recommendations
1. **Test Edit Exam**: 
   - Navigate to `admin/exams.php`
   - Click "Edit" on any exam
   - Verify all fields load correctly
   - Make changes and save
   - Confirm changes persist

2. **Test Question Shuffling**:
   - Create exam with 10 questions in database
   - Set `total_questions = 5`
   - Enable "Shuffle Questions"
   - Take exam multiple times as student
   - Verify only 5 questions appear
   - Verify different questions appear each time (if shuffle enabled)

3. **Test Time Tracking**:
   - Complete an exam as student
   - Check admin test takers page
   - Verify "Time Spent" shows accurate duration
   - Format should be: "X min Y sec" or "X hr Y min Z sec"

4. **Test Scoring**:
   - Create questions with different point values (e.g., 2, 3, 5 points)
   - Complete exam
   - Verify score shows as "earned / total" (e.g., "7.00 / 10.00")
   - Verify total matches sum of question points, not duration

### Known Limitations

1. **Shuffle Consistency**: When shuffle is enabled, each page load may show different questions. Consider implementing session-based question locking if needed.

2. **Question Pool Size**: Ensure the question bank has at least as many questions as `total_questions` value, otherwise fewer questions will appear.

3. **Theory Question Grading**: Theory questions still require manual grading (existing behavior, not changed).

### Future Enhancements (Suggested)

1. Lock shuffled questions per session (store selected question IDs in session table)
2. Add warning when `total_questions` exceeds available questions in database
3. Add bulk edit for exams
4. Add question difficulty levels for weighted shuffling
5. Add exam templates for quick creation

### Support

For issues or questions:
1. Check this changelog for recent changes
2. Review `README.md` for general documentation
3. Check `INSTALLATION_STEPS.md` for setup guidance
4. Review error logs in `/var/log/apache2/error.log` or PHP error log

---

**Summary of Changes**:
- ✅ Issue #1 Fixed: `edit_exam.php` now exists and functions properly
- ✅ Issue #2 Fixed: Question count now respects `total_questions` setting
- ✅ Issue #3 Fixed: Shuffle toggle added and functional
- ✅ Issue #4 Fixed: Time tracking now accurate
- ✅ Issue #5 Fixed: Scoring based on actual question points

**Version**: 2.1  
**Release Date**: December 10, 2025  
**Status**: Production Ready ✅
