# Quick Installation Steps - Automatic Video Processing

## Prerequisites
- Existing proctor system installed and working
- FFmpeg installed on server
- PHP CLI access
- Write permissions on project directories

---

## Installation Steps

### 1. Copy New Files
Copy these new files to your server:

```bash
# New video processing utilities
/proctor/video_processor.php
/proctor/process_video_background.php

# Updated files
/proctor/finalize_upload.php (REPLACE existing)
/admin/test_takers.php (REPLACE existing)
/assets/css/style.css (REPLACE existing)
```

### 2. Set Permissions
Make the background script executable:

```bash
cd /path/to/your/proctor/proctor/
chmod +x process_video_background.php
```

Ensure directories are writable:

```bash
chmod 775 /path/to/your/proctor/videos/
chmod 775 /path/to/your/proctor/proctor/chunks/
chmod 775 /path/to/your/proctor/proctor/final_videos/
```

### 3. Verify FFmpeg
Check FFmpeg is installed:

```bash
which ffmpeg
ffmpeg -version
```

If not installed:

```bash
# Ubuntu/Debian
sudo apt-get update
sudo apt-get install ffmpeg

# CentOS/RHEL
sudo yum install ffmpeg

# macOS
brew install ffmpeg
```

### 4. Test the System

#### Test 1: Take a Test Exam
1. Login as student (username: `student`, password: `password`)
2. Start an exam
3. Allow webcam access
4. Answer a few questions
5. Submit the exam
6. Wait 30-60 seconds

#### Test 2: Check Admin Panel
1. Login as admin (username: `admin`, password: `password`)
2. Go to "Test Takers" page
3. Look for the student's exam
4. You should see:
   - Initially: "Upload in Progress" or "Processing..."
   - After processing: Green "View Video" button
5. Click "View Video" to watch the recording

#### Test 3: Verify Video File
```bash
# Check if video was created
ls -lh /path/to/your/proctor/videos/*.mp4

# Check processing log
cat /path/to/your/proctor/videos/processing_log_*.txt
```

### 5. Monitor Logs
Check for any errors:

```bash
# PHP error log
tail -f /var/log/apache2/error.log

# Or for nginx
tail -f /var/log/nginx/error.log

# Look for "Video Processing" entries
grep "Video Processing" /var/log/apache2/error.log
```

---

## Verification Checklist

- [ ] FFmpeg installed and accessible
- [ ] New files copied to correct locations
- [ ] `process_video_background.php` is executable
- [ ] Directories have write permissions
- [ ] Test exam completed successfully
- [ ] Video automatically processed
- [ ] "View Video" button appears in admin panel
- [ ] Video plays correctly when clicked
- [ ] No errors in server logs

---

## Troubleshooting

### Issue: "FFmpeg not found"
**Solution:**
```bash
sudo apt-get install ffmpeg
# Then verify
which ffmpeg
```

### Issue: "Permission denied"
**Solution:**
```bash
chmod 775 /path/to/proctor/videos/
chmod 775 /path/to/proctor/proctor/chunks/
chmod +x /path/to/proctor/proctor/process_video_background.php
```

### Issue: Video not processing automatically
**Solution:**
1. Check processing log: `/videos/processing_log_[session_id].txt`
2. Check PHP error log for "Video Processing" errors
3. Verify `video_upload_complete = 1` in database:
   ```sql
   SELECT * FROM student_exam_sessions WHERE session_id = [ID];
   ```
4. Try manual retry from admin panel

### Issue: "Processing..." stuck forever
**Solution:**
1. Check if background process is running:
   ```bash
   ps aux | grep process_video_background
   ```
2. Check processing log for errors
3. Click "Retry" button in admin panel
4. Or manually process: `/admin/process_video.php?session_id=[ID]`

---

## Files Modified Summary

### New Files (3)
1. `/proctor/video_processor.php` - Core processing functions
2. `/proctor/process_video_background.php` - Background worker script
3. `/AUTOMATIC_VIDEO_PROCESSING.md` - Complete documentation

### Modified Files (3)
1. `/proctor/finalize_upload.php` - Triggers automatic processing
2. `/admin/test_takers.php` - Updated UI for auto-processed videos
3. `/assets/css/style.css` - Added status indicator styles

### No Changes Required
- Database schema (no changes needed!)
- Other PHP files
- JavaScript files
- Configuration files

---

## Rollback (If Needed)

To revert to manual processing only:

1. Edit `/proctor/finalize_upload.php`:
   - Remove line: `require_once __DIR__ . '/video_processor.php';`
   - Remove line: `process_video_background($session_id);`

2. Keep all other files (they won't cause issues)

3. Admin can still manually process videos at `/admin/process_video.php`

---

## Success Indicators

✅ **Working correctly if:**
- Student can take exam and submit successfully
- Video chunks upload during exam
- After 30-60 seconds, "View Video" button appears
- Clicking button opens working video
- No errors in server logs

❌ **Not working if:**
- "Processing..." indicator never changes
- No video file created in `/videos/` directory
- Errors in processing log
- "View Video" button never appears

---

## Next Steps

After successful installation:

1. **Monitor first few exams** - Check logs and verify videos process correctly
2. **Set up disk space monitoring** - Videos can consume significant space
3. **Plan cleanup strategy** - Delete old chunks after processing
4. **Consider backups** - Backup `/videos/` directory regularly
5. **Review documentation** - Read full guide in `AUTOMATIC_VIDEO_PROCESSING.md`

---

## Support

If you encounter issues:

1. Check processing logs: `/videos/processing_log_*.txt`
2. Check PHP error logs
3. Verify FFmpeg installation: `ffmpeg -version`
4. Test manual processing: `/admin/process_video.php?session_id=[ID]`
5. Review full documentation: `AUTOMATIC_VIDEO_PROCESSING.md`

---

**Installation Complete!** 🎉

Your proctor system now automatically processes exam videos without admin intervention.
