<?php
// create_grade.php - Admin Create New Grade

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Create New Grade';

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $grade_name = trim($_POST['grade_name'] ?? '');
    $description = trim($_POST['description'] ?? '');

    if (empty($grade_name)) {
        $error = 'Grade Name is required.';
    } else {
        // Check for duplicate grade name
        $sql_check = "SELECT grade_id FROM grades WHERE grade_name = ?";
        $result_check = execute_query($mysqli, $sql_check, 's', [$grade_name]);

        if ($result_check && $result_check->num_rows > 0) {
            $error = "A grade with the name '{$grade_name}' already exists.";
        } else {
            $sql_insert = "INSERT INTO grades (grade_name, description) VALUES (?, ?)";
            
            $insert_id = execute_insert($mysqli, $sql_insert, 'ss', [
                $grade_name, 
                $description
            ]);

            if ($insert_id) {
                $_SESSION['success_message'] = "Grade '{$grade_name}' created successfully.";
                redirect('admin/grades.php');
            } else {
                $error = 'Error creating grade.';
            }
        }
    }
}

include 'includes/header.php';

if ($error): ?>
    <p class="error"><?php echo $error; ?></p>
<?php endif; ?>

        <form method="POST" action="create_grade.php">
            <div class="form-group">
                <label for="grade_name">Grade Name (e.g., RT, JR, SR):</label>
                <input type="text" id="grade_name" name="grade_name" value="<?php echo htmlspecialchars($_POST['grade_name'] ?? ''); ?>" required maxlength="50">
            </div>
            <div class="form-group">
                <label for="description">Description (Optional):</label>
                <textarea id="description" name="description"><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
            </div>
            <button type="submit">Create Grade</button>
        </form>
<?php
include 'includes/footer.php';
?>
