<?php
// admin/process_video.php - Concatenate and convert video chunks for a session

require_once '../db.php';
require_admin();

$session_id = filter_input(INPUT_GET, 'session_id', FILTER_VALIDATE_INT);

if (!$session_id) {
    redirect('admin/test_takers.php', 'error', 'Invalid session ID.');
}

// 1. Fetch session and chunk data
$sql_session = "SELECT student_id, public_session_id FROM student_exam_sessions WHERE session_id = ?";
$session_data = execute_query($mysqli, $sql_session, 'i', [$session_id])->fetch_assoc();

if (!$session_data) {
    redirect('admin/test_takers.php', 'error', 'Session not found.');
}

$sql_chunks = "SELECT file_path FROM exam_video_chunks WHERE session_id = ? ORDER BY chunk_index ASC";
$chunks_result = execute_query($mysqli, $sql_chunks, 'i', [$session_id]);
$chunks = $chunks_result ? $chunks_result->fetch_all(MYSQLI_ASSOC) : [];

if (empty($chunks)) {
    redirect('admin/test_takers.php', 'error', 'No video chunks found for this session.');
}

// 2. Prepare for FFmpeg
// The base directory is the project root (proctor_project/proctor/)
	$base_dir = PROJECT_ROOT_DIR;
	$output_dir = $base_dir . 'videos/';
	
	// Ensure the output directory exists
	if (!is_dir($output_dir)) {
	    mkdir($output_dir, 0777, true);
	}
$temp_list_file = $output_dir . 'list_' . $session_id . '.txt';
// Use the student's username (staff_id) for the output file name
	$sql_username = "SELECT u.username FROM users u JOIN student_exam_sessions ses ON u.user_id = ses.student_id WHERE ses.session_id = ?";
	$username_result = execute_query($mysqli, $sql_username, 'i', [$session_id]);
	$username_data = $username_result->fetch_assoc();
	$username = $username_data['username'] ?? 'unknown';
	
	$output_file_name = $username . '_' . $session_id . '.mp4';
$output_file_path = $output_dir . $output_file_name;

// 3. Create FFmpeg concat list file
$list_content = '';
foreach ($chunks as $chunk) {
    // FFmpeg requires paths relative to the list file or absolute paths
// The file_path in the database is already the absolute path from the server's perspective.
	// We just need to ensure it's correct for FFmpeg.
	$absolute_chunk_path = $chunk['file_path'];
    $list_content .= "file '" . $absolute_chunk_path . "'\n";
}
file_put_contents($temp_list_file, $list_content);

// 4. Execute FFmpeg command
// -f concat: Use the concat demuxer
// -safe 0: Allow unsafe file names (needed for absolute paths)
// -i: Input file (the list file)
// -c copy: Stream copy (fastest, no re-encoding)
// -y: Overwrite output file if it exists
// The chunks are WebM format, so we should specify the input format if we are having issues.
	// We also add a more explicit check for the FFmpeg binary.
	$ffmpeg_binary = trim(shell_exec('which ffmpeg'));
	if (empty($ffmpeg_binary)) {
	    $user_error = 'Video processing failed. FFmpeg binary not found on the server.';
	    redirect('admin/test_takers.php', 'error', $user_error);
	}
	
	// Use -f webm for input if the chunks are webm (which they are from MediaRecorder)
	// The concat demuxer handles the format of the files in the list, but explicitly specifying the input format
	// can sometimes help. However, since the files are already WebM, -c copy should work.
	// Let's try adding -v error to ensure only errors are outputted, and then capture that.
	$ffmpeg_command = "$ffmpeg_binary -f concat -safe 0 -i " . escapeshellarg($temp_list_file) . " -c copy -y " . escapeshellarg($output_file_path) . " 2>&1";

// Execute the command (using shell_exec for simplicity, but consider backgrounding for production)
// Execute the command and capture the output
	$output = shell_exec($ffmpeg_command);
	
	// Check the exit status of the last executed command
	$exit_code = 0;
	if (function_exists('shell_exec')) {
	    // Use exec to get the exit code
	    exec($ffmpeg_command, $output_array, $exit_code);
	    $output = implode("\n", $output_array);
	}

// 5. Clean up and update database
unlink($temp_list_file);

if (file_exists($output_file_path)) {
    // Update the database with the final video path
    $relative_path = 'videos/' . $output_file_name;
    $sql_update = "UPDATE student_exam_sessions SET proctoring_video_path = ? WHERE session_id = ?";
    execute_insert($mysqli, $sql_update, 'si', [$relative_path, $session_id]);
    
    redirect('admin/test_takers.php', 'success', 'Video successfully processed and saved as ' . $output_file_name);
} else {
	    // Log the error output for debugging
	    error_log("FFmpeg Error for session $session_id (Exit Code: $exit_code): " . $output);
	    
	    // Provide the FFmpeg output to the user for immediate debugging
	    $error_output = trim($output);
	    if (empty($error_output)) {
	        $error_output = "FFmpeg command executed but output file was not created. Check server logs for details. Exit Code: $exit_code";
	    }
	    
	    $user_error = 'Video processing failed. FFmpeg Output: ' . substr($error_output, 0, 200) . '...';
	    redirect('admin/test_takers.php', 'error', $user_error);
	}

// Note: The chunks themselves are not deleted here, as they might be needed for re-processing.
?>
