# Proctored Exam Web Application Setup Instructions

This document provides the necessary steps to set up and run the **Proctored Exam Web Application** developed using PHP, MySQLi, and advanced JavaScript Web Workers for ultra-fast video proctoring uploads.

## 1. System Requirements

*   **Web Server:** Apache, Nginx, or similar (with PHP support)
*   **PHP:** Version 7.4 or higher (with `mysqli` extension enabled)
*   **Database:** MySQL or MariaDB
*   **Browser:** Modern browser supporting **Web Workers** and **MediaRecorder API** (e.g., Chrome, Firefox, Edge)

## 2. Project Structure

The generated system follows the required folder structure:

\`\`\`
/project
    /admin
        levels.php
        create_level.php
        edit_level.php
        exams.php
        create_exam.php
        questions.php
    /student
        start_exam.php
        take_exam.php
        submit_exam.php
        exam_submitted.php
    /proctor
        upload_worker.js
        upload_chunk.php
        finalize_upload.php
        /chunks/ (created automatically, for video chunks)
        /final_videos/ (created automatically, for future stitched videos)
    /assets
        /js
            proctoring.js
        /css
            style.css
    db.php
    index.php (Login/Home)
    logout.php
    schema.sql
    SETUP_INSTRUCTIONS.md
\`\`\`

## 3. Database Setup

### A. Create Database

Open your MySQL client (e.g., phpMyAdmin, MySQL Workbench, or command line) and create a new database.

\`\`\`sql
CREATE DATABASE proctored_exam_app;
\`\`\`

### B. Import Schema

Import the provided `schema.sql` file into the newly created database. This will create all necessary tables and two initial users (`admin` and `student`).

\`\`\`bash
mysql -u your_username -p proctored_exam_app < /path/to/project/schema.sql
\`\`\`

### C. Update Database Credentials

Edit the `db.php` file to match your database credentials:

\`\`\`php
// db.php - Database Connection and Utility Functions

// Database configuration
define('DB_SERVER', 'localhost');
define('DB_USERNAME', 'root'); // <-- CHANGE THIS
define('DB_PASSWORD', 'password'); // <-- CHANGE THIS
define('DB_NAME', 'proctored_exam_app'); // <-- CHANGE THIS if you used a different name
// ...
\`\`\`

## 4. Web Server Configuration

### A. Place Project Files

Place the entire `/project` directory into your web server's document root (e.g., `/var/www/html/` for Apache or `htdocs/` for XAMPP).

### B. Configure Base URL

Edit the `db.php` file to set the correct `BASE_URL`. If you placed the project in a subfolder named `project`, the default should be:

\`\`\`php
// ...
// Base URL for the project (adjust as needed)
define('BASE_URL', 'http://localhost/project/'); // <-- ADJUST THIS
// ...
\`\`\`

### C. Ensure Write Permissions

The system needs write permissions to create the video chunk directories and save files. Ensure the web server user has write access to the `/project/proctor/` directory.

\`\`\`bash
# Example for Linux/Apache
sudo chown -R www-data:www-data /path/to/project/proctor
sudo chmod -R 775 /path/to/project/proctor
\`\`\`

## 5. Running the Application

1.  Open your web browser and navigate to the `BASE_URL` (e.g., `http://localhost/project/`). You will be redirected to `index.php` (the login page).

2.  **Login as Admin:**
    *   **Username:** `admin`
    *   **Password:** `password` (The hash in `schema.sql` is for this password)
    *   **Action:** Create Levels, Exams, and Questions via the Admin Panel.

3.  **Login as Student:**
    *   **Username:** `student`
    *   **Password:** `password`
    *   **Action:** Select and start an exam from `student/start_exam.php`.

## 6. Key Feature: Ultra-Fast Proctoring Upload

The system implements the required ultra-fast video upload mechanism:

*   **Frontend (`assets/js/proctoring.js`):** Uses the `MediaRecorder` API to split the webcam stream into **1-second micro-chunks**.
*   **Parallelism (`proctor/upload_worker.js`):** Uses **JavaScript Web Workers** to manage a pool of concurrent upload threads, avoiding the browser's single-thread bottleneck.
*   **Backend (`proctor/upload_chunk.php`):** Securely receives and saves the micro-chunks to the `/proctor/chunks/` directory, recording metadata in the `exam_video_chunks` table.
*   **Instant Submission (`student/submit_exam.php`):** The exam answers are saved instantly, and the student is redirected immediately. The remaining video chunks continue to upload in the background via the Web Workers (a "fire and forget" mechanism).
*   **Finalization (`proctor/finalize_upload.php`):** A final call is made by the Web Worker logic to mark the session as `video_upload_complete` in the database only after the last chunk has been successfully uploaded.

This design ensures a **non-blocking, instant submission experience** for the student while guaranteeing that all proctoring video data is eventually uploaded.

---
*Generated by Manus AI*
