<?php
// admin/create_user.php - Admin interface for single test-taker creation

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Create Test-Taker';

$error = '';
$success = '';

// Function to generate a random alphanumeric password
function generate_random_password($length = 10) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $password = '';
    for ($i = 0; $i < $length; $i++) {
        $password .= $characters[rand(0, strlen($characters) - 1)];
    }
    return $password;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $full_name = trim($_POST['full_name'] ?? '');
    // Staff ID is now treated as the Username
    $staff_id = $username;
    $email = trim($_POST['email'] ?? '');
    $grade = trim($_POST['grade'] ?? '');
    $user_type = 'Student'; // Always 'Student' for this form

    if (empty($username) || empty($full_name) || empty($email) || empty($grade)) {
        $error = 'All fields are required.';
    } else {
        // 1. Generate a random password
        $raw_password = generate_random_password();
        $password_hash = password_hash($raw_password, PASSWORD_DEFAULT);

        // 2. Check for existing user (username or staff_id or email)
        // Check for existing user (username or email)
        $sql_check = "SELECT user_id FROM users WHERE username = ? OR email = ?";
        $result_check = execute_query($mysqli, $sql_check, 'ss', [$username, $email]);

        if ($result_check && $result_check->num_rows > 0) {
            $error = 'A user with this Staff ID/Username or Email already exists.';
        } else {
            // 3. Insert new user
            // Since username is now the Staff ID, we set staff_id = username
            $sql_insert = "INSERT INTO users (username, password_hash, full_name, user_type, grade, staff_id, email) VALUES (?, ?, ?, ?, ?, ?, ?)";
            $user_id = execute_insert($mysqli, $sql_insert, 'sssssss', [$username, $password_hash, $full_name, $user_type, $grade, $username, $email]);

            if ($user_id) {
                // 4. Simulate sending email with the generated password
                // NOTE: In a real application, you would use a library like PHPMailer here.
                $email_subject = "Your New Exam Portal Account Details";
                $email_body = "Dear $full_name,\n\nYour account has been created for the Exam Portal.\n\nStaff ID/Username: $username\nTemporary Password: $raw_password\n\nPlease log in and change your password immediately.\n\nRegards,\nAdmin Team";
                
                if (send_email($email, $email_subject, $email_body)) {
                    $success = "Test-taker **$full_name** created successfully. Temporary password sent to **$email**.";
                } else {
                    $success = "Test-taker **$full_name** created successfully. **WARNING: Failed to send temporary password email to $email.** Temporary Password: $raw_password";
                }
                
                // Clear form fields
                $_POST = [];

            } else {
                $error = 'Database error: Could not create user.';
            }
        }
    }
}

// Fetch all grades from the new 'grades' table
$sql_grades = "SELECT grade_name AS grade FROM grades ORDER BY grade_name";
$result_grades = execute_query($mysqli, $sql_grades);
$grades = $result_grades ? $result_grades->fetch_all(MYSQLI_ASSOC) : [];

include 'includes/header.php';

if ($error): ?>
    <p class="error"><?php echo $error; ?></p>
<?php endif; ?>
<?php if ($success): ?>
    <p class="success"><?php echo $success; ?></p>
<?php endif; ?>

        <form method="POST" action="create_user.php">
            <div class="form-group">
                <label for="full_name">Full Name:</label>
                <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($_POST['full_name'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="username">Staff ID/Username:</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="grade">Grade:</label>
                <select id="grade" name="grade" required>
                    <option value="">Select Grade</option>
                    <?php foreach ($grades as $g): ?>
                        <option value="<?php echo htmlspecialchars($g['grade']); ?>" 
                            <?php echo (($_POST['grade'] ?? '') === $g['grade']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($g['grade']); ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button type="submit">Create Test-Taker</button>
        </form>
<?php
include 'includes/footer.php';
?>
