<?php
// exams.php - Admin Exams Management

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Exams Management';

// Handle Delete Request
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $exam_id = (int) $_GET['id'];
    $sql_delete = "DELETE FROM exams WHERE exam_id = ?";
    $affected_rows = execute_non_query($mysqli, $sql_delete, 'i', [$exam_id]);

    if ($affected_rows) {
        $_SESSION['success_message'] = "Exam deleted successfully.";
    } else {
        $_SESSION['error_message'] = "Error deleting exam or exam not found.";
    }
    redirect('admin/exams.php');
}

// Fetch all exams
$sql_select = "SELECT E.*, E.target_grade AS grade_name
               FROM exams E
               ORDER BY E.exam_id DESC";
$result = execute_query($mysqli, $sql_select);
$exams = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

include 'includes/header.php';
$i = 1;
?>
    <style>
        /* Toggle Switch Styling */
        .switch {
            position: relative;
            display: inline-block;
            width: 40px;
            height: 20px;
        }

        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }

        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            -webkit-transition: .4s;
            transition: .4s;
        }

        .slider:before {
            position: absolute;
            content: "";
            height: 16px;
            width: 16px;
            left: 2px;
            bottom: 2px;
            background-color: white;
            -webkit-transition: .4s;
            transition: .4s;
        }

        input:checked + .slider {
            background-color: #2196F3;
        }

        input:focus + .slider {
            box-shadow: 0 0 1px #2196F3;
        }

        input:checked + .slider:before {
            -webkit-transform: translateX(20px);
            -ms-transform: translateX(20px);
            transform: translateX(20px);
        }

        /* Rounded sliders */
        .slider.round {
            border-radius: 20px;
        }

        .slider.round:before {
            border-radius: 50%;
        }
    </style>
<p><a href="<?php echo BASE_URL; ?>admin/create_exam.php"><button>Create New Exam</button></a></p>

<?php if (empty($exams)): ?>
    <p>No exams found. Please create a new one.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>S/n</th>
                <th hidden>ID</th>
                <th>Title</th>
                <th>Target Grade</th>
                <th>Mode</th>
                <th>Questions</th>
                <th>Duration (min)</th>
                <th>Shuffle (Toggle)</th>
                <th>Active</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($exams as $exam): ?>
                <tr>
                    <td><?= $i++; ?></td>
                    <td hidden><?php echo htmlspecialchars($exam['exam_id']); ?></td>
                    <td><?php echo htmlspecialchars($exam['exam_title']); ?></td>
                    <td><?php echo htmlspecialchars($exam['grade_name']); ?></td>
                    <td><?php echo htmlspecialchars($exam['exam_mode']); ?></td>
                    <td><?php echo htmlspecialchars($exam['total_questions']); ?></td>
                    <td><?php echo htmlspecialchars($exam['duration_minutes']); ?></td>
                                        <td>
                        <label class="switch">
                            <input type="checkbox" class="shuffle-toggle" data-exam-id="<?php echo $exam['exam_id']; ?>" <?php echo $exam['shuffle_questions'] ? 'checked' : ''; ?>>
                            <span class="slider round"></span>
                        </label>
                    </td>
                    <td><?php echo $exam['is_active'] ? 'Yes' : 'No'; ?></td>
                    <td class="actions">

                        <a href="<?php echo BASE_URL; ?>admin/edit_exam.php?id=<?php echo $exam['exam_id']; ?>">Edit</a>
                        <a href="<?php echo BASE_URL; ?>admin/exams.php?action=delete&id=<?php echo $exam['exam_id']; ?>"
                            onclick="return confirm('Are you sure you want to delete this exam? All associated questions and student sessions will be deleted.');">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const toggles = document.querySelectorAll('.shuffle-toggle');

        toggles.forEach(toggle => {
            toggle.addEventListener('change', function() {
                const examId = this.getAttribute('data-exam-id');
                const currentStatus = this.checked ? 1 : 0;
                const toggleElement = this;

                // Disable the toggle during the AJAX call
                toggleElement.disabled = true;

                fetch('toggle_shuffle.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'exam_id=' + examId + '&current_status=' + currentStatus
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        // Success: The new status is already reflected by the toggle state
                        console.log('Toggle Success:', data.message, 'New Status:', data.new_status);
                    } else {
                        // Failure: Revert the toggle state
                        toggleElement.checked = !currentStatus;
                        alert('Error: ' + data.message);
                        console.error('Toggle Failure:', data.message);
                    }
                })
                .catch(error => {
                    // Network or other error: Revert the toggle state
                    toggleElement.checked = !currentStatus;
                    alert('An error occurred while updating the shuffle setting.');
                    console.error('Error:', error);
                })
                .finally(() => {
                    // Re-enable the toggle
                    toggleElement.disabled = false;
                });
            });
        });
    });
</script>

<?php
	include 'includes/footer.php';
	?>