<?php
// grades.php - Admin Grades Management

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Grades Management';

// Handle Delete Request
if (isset($_GET['action']) && $_GET['action'] === 'delete' && isset($_GET['id'])) {
    $grade_id = (int) $_GET['id'];

    // Check if any active exam is assigned to this grade
    $sql_check_exams = "SELECT COUNT(*) FROM exams WHERE target_grade = (SELECT grade_name FROM grades WHERE grade_id = ?) AND is_active = 1";
    $count = execute_query($mysqli, $sql_check_exams, 'i', [$grade_id])->fetch_row()[0] ?? 0;

    if ($count > 0) {
        $_SESSION['error_message'] = "Cannot delete grade. An active exam is currently assigned to this grade.";
    } else {
        // Check if any user is assigned to this grade
        $sql_check_users = "SELECT COUNT(*) FROM users WHERE grade = (SELECT grade_name FROM grades WHERE grade_id = ?)";
        $user_count = execute_query($mysqli, $sql_check_users, 'i', [$grade_id])->fetch_row()[0] ?? 0;

        if ($user_count > 0) {
            $_SESSION['error_message'] = "Cannot delete grade. $user_count user(s) are currently assigned to this grade.";
        } else {
            $sql_delete = "DELETE FROM grades WHERE grade_id = ?";
            $affected_rows = execute_non_query($mysqli, $sql_delete, 'i', [$grade_id]);

            if ($affected_rows) {
                $_SESSION['success_message'] = "Grade deleted successfully.";
            } else {
                $_SESSION['error_message'] = "Error deleting grade or grade not found.";
            }
        }
    }
    redirect('admin/grades.php');
}

// Fetch all grades
$sql_select = "SELECT * FROM grades ORDER BY grade_name";
$result = execute_query($mysqli, $sql_select);
$grades = $result ? $result->fetch_all(MYSQLI_ASSOC) : [];

include 'includes/header.php';
$i = 1;
?>
<h2><?php echo $page_title; ?></h2>
<p><a href="<?php echo BASE_URL; ?>admin/create_grade.php"><button>Create New Grade</button></a></p>

<?php if (empty($grades)): ?>
    <p>No grades found. Please create a new one.</p>
<?php else: ?>
    <table>
        <thead>
            <tr>
                <th>S/n</th>
                <th hidden>ID</th>
                <th>Name</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($grades as $grade): ?>
                <tr>
                    <td><?= $i++; ?></td>
                    <td hidden><?php echo htmlspecialchars($grade['grade_id']); ?></td>
                    <td><?php echo htmlspecialchars($grade['grade_name']); ?></td>
                    <td><?php echo htmlspecialchars($grade['description']); ?></td>
                    <td class="actions">
                        <a href="<?php echo BASE_URL; ?>admin/edit_grade.php?id=<?php echo $grade['grade_id']; ?>">Edit</a>
                        <a href="<?php echo BASE_URL; ?>admin/grades.php?action=delete&id=<?php echo $grade['grade_id']; ?>"
                            onclick="return confirm('Are you sure you want to delete this grade? This action cannot be undone.');">Delete</a>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

<?php
include 'includes/footer.php';
?>