<?php
// admin/index.php - Admin Dashboard

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Admin Dashboard';

// --- Fetch Key Statistics ---

// 1. Total Test Takers
$sql_total_users = "SELECT COUNT(user_id) AS total_users FROM users WHERE user_type = 'Student'";
$total_users = execute_query($mysqli, $sql_total_users)->fetch_assoc()['total_users'] ?? 0;

// 2. Total Exams
$sql_total_exams = "SELECT COUNT(exam_id) AS total_exams FROM exams";
$total_exams = execute_query($mysqli, $sql_total_exams)->fetch_assoc()['total_exams'] ?? 0;

// 3. Total Questions
$sql_total_questions = "SELECT COUNT(question_id) AS total_questions FROM exam_questions";
$total_questions = execute_query($mysqli, $sql_total_questions)->fetch_assoc()['total_questions'] ?? 0;

// 4. Total Exam Sessions (Attempts)
$sql_total_sessions = "SELECT COUNT(session_id) AS total_sessions FROM student_exam_sessions";
$total_sessions = execute_query($mysqli, $sql_total_sessions)->fetch_assoc()['total_sessions'] ?? 0;

// 5. Completed Exams
$sql_completed_sessions = "SELECT COUNT(session_id) AS completed_sessions FROM student_exam_sessions WHERE is_submitted = 1";
$completed_sessions = execute_query($mysqli, $sql_completed_sessions)->fetch_assoc()['completed_sessions'] ?? 0;

// --- Fetch Recent Activity ---

// 6. 5 Most Recent Completed Exams
$sql_recent_sessions = "
    SELECT 
        U.full_name, 
        E.exam_title, 
        SES.end_time, 
        SES.total_score
    FROM 
        student_exam_sessions SES
    JOIN 
        users U ON SES.student_id = U.user_id
    JOIN 
        exams E ON SES.exam_id = E.exam_id
    WHERE 
        SES.is_submitted = 1
    ORDER BY 
        SES.end_time DESC
    LIMIT 5
";
$recent_sessions_result = execute_query($mysqli, $sql_recent_sessions);
$recent_sessions = $recent_sessions_result ? $recent_sessions_result->fetch_all(MYSQLI_ASSOC) : [];


include 'includes/header.php';
?>

<div class="admin-content">
    <style>
        .dashboard-stats {
            display: flex;
            flex-wrap: wrap;
            gap: 20px;
            margin-bottom: 30px;
        }

        .stat-card {
            background-color: #ffffff;
            border: 1px solid #e5e7eb;
            border-radius: 8px;
            padding: 20px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.05);
            flex: 1 1 200px;
            min-width: 200px;
        }

        .stat-card h3 {
            margin-top: 0;
            font-size: 1.1em;
            color: #4b5563;
        }

        .stat-card p {
            font-size: 2.5em;
            font-weight: 700;
            color: #1f2937;
            margin: 5px 0 0 0;
        }

        .recent-activity h2 {
            border-bottom: 2px solid #e5e7eb;
            padding-bottom: 10px;
            margin-bottom: 20px;
        }
    </style>

    <div class="dashboard-stats">
        <div class="stat-card" style="flex: 1 1 100%;">
            <a href="test_takers.php" class="btn"
                style="display: block; text-align: center; padding: 10px; background-color: #3b82f6; color: white; text-decoration: none; border-radius: 4px; margin-bottom: 10px;">
                Go to Test-Takers List & Video Processing
            </a>
            <a href="download_results.php" class="btn"
                style="display: block; text-align: center; padding: 10px; background-color: #10b981; color: white; text-decoration: none; border-radius: 4px;">
                Download All Completed Exam Results (CSV)
            </a>
        </div>
        <div class="stat-card">
            <h3>Total Test-Takers</h3>
            <p><?php echo $total_users; ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Exams</h3>
            <p><?php echo $total_exams; ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Questions</h3>
            <p><?php echo $total_questions; ?></p>
        </div>
        <div class="stat-card">
            <h3>Total Attempts</h3>
            <p><?php echo $total_sessions; ?></p>
        </div>
        <div class="stat-card">
            <h3>Completed Exams</h3>
            <p><?php echo $completed_sessions; ?></p>
        </div>
    </div>

    <div class="recent-activity">
        <h2>Recent Completed Exams</h2>
        <?php if (empty($recent_sessions)): ?>
            <p>No exams have been completed yet.</p>
        <?php else: ?>
            <table>
                <thead>
                    <tr>
                        <th>S/N</th>
                        <th>Test-Taker</th>
                        <th>Exam Title</th>
                        <th>Score</th>
                        <th>Completion Time</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1;
                    foreach ($recent_sessions as $session): ?>
                        <tr>
                            <td><?= $i ?></td>
                            <td><?php echo htmlspecialchars($session['full_name']); ?></td>
                            <td><?php echo htmlspecialchars($session['exam_title']); ?></td>
                            <td><?php echo htmlspecialchars(sprintf("%.2f", $session['total_score'])); ?></td>
                            <td><?php echo htmlspecialchars($session['end_time']); ?></td>
                        </tr>
                        <?php $i++; endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<?php
include 'includes/footer.php';
?>