<?php
// toggle_shuffle.php - AJAX endpoint to toggle the shuffle_questions setting for an exam

header('Content-Type: application/json');

require_once '../db.php';
require_admin();

$response = ['success' => false, 'message' => 'Invalid request.'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $exam_id = (int)($_POST['exam_id'] ?? 0);
    $current_status = (int)($_POST['current_status'] ?? -1);

    if ($exam_id > 0 && ($current_status === 0 || $current_status === 1)) {
        
        // The JavaScript sends the NEW intended status, so we use it directly.
        // The JavaScript sends the NEW intended status, so we use it directly.
        $new_status = $current_status;

        // Log the received data for debugging
        error_log("Toggle Shuffle: Received exam_id=$exam_id, new_status=$new_status");

        // Update the database
        $sql_update = "UPDATE exams SET shuffle_questions = ? WHERE exam_id = ?";
        $affected_rows = execute_non_query($mysqli, $sql_update, 'ii', [$new_status, $exam_id]);

        if ($affected_rows) {
            // After successful update, fetch the actual status from the database to confirm
            $sql_check = "SELECT shuffle_questions FROM exams WHERE exam_id = ?";
            $result_check = execute_query($mysqli, $sql_check, 'i', [$exam_id]);
            
            if ($result_check && $result_check->num_rows > 0) {
                $db_status = $result_check->fetch_assoc()['shuffle_questions'];
                $response['success'] = true;
                $response['new_status'] = (int)$db_status;
                $response['message'] = "Exam shuffle setting updated successfully. DB Status: " . $db_status;
                error_log("Toggle Shuffle: Success. DB Status: " . $db_status);
            } else {
                // Should not happen if $affected_rows is true, but good for robustness
                $response['message'] = "Update succeeded but failed to verify status.";
                error_log("Toggle Shuffle: Update succeeded but verification failed.");
            }
        } else {
            $response['message'] = "Error updating exam shuffle setting or exam not found. MySQL Error: " . $mysqli->error;
            error_log("Toggle Shuffle: Update failed. MySQL Error: " . $mysqli->error);
        }
    } else {
        $response['message'] = "Missing or invalid parameters.";
    }
}

$mysqli->close();
echo json_encode($response);
?>
