<?php
// edit_exam.php - Admin Edit Exam

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Edit Exam';

$error = '';
$success = '';
$exam_modes = ['Mixed', 'MCQ', 'Theory', 'Fill-in-the-gaps'];

// Get exam ID from URL
$exam_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($exam_id <= 0) {
    $_SESSION['error_message'] = 'Invalid exam ID.';
    redirect('admin/exams.php');
}

// Fetch exam details
$sql_exam = "SELECT * FROM exams WHERE exam_id = ?";
$result = execute_query($mysqli, $sql_exam, 'i', [$exam_id]);

if (!$result || $result->num_rows === 0) {
    $_SESSION['error_message'] = 'Exam not found.';
    redirect('admin/exams.php');
}

$exam = $result->fetch_assoc();

// Fetch all grades
$sql_grades = "SELECT grade_name AS grade FROM grades ORDER BY grade_name";
$grades_result = execute_query($mysqli, $sql_grades);
$grades = $grades_result ? $grades_result->fetch_all(MYSQLI_ASSOC) : [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $target_grade = trim($_POST['target_grade'] ?? '');
    $exam_title = trim($_POST['exam_title'] ?? '');
    $exam_description = trim($_POST['exam_description'] ?? '');
    $duration_minutes = (int) ($_POST['duration_minutes'] ?? 0);
    $total_questions = (int) ($_POST['total_questions'] ?? 0);
    $exam_mode = $_POST['exam_mode'] ?? '';
    $is_active = isset($_POST['is_active']) ? 1 : 0;
    $shuffle_questions = isset($_POST['shuffle_questions']) ? 1 : 0;

    if (empty($exam_title) || empty($target_grade) || !in_array($exam_mode, $exam_modes) || $duration_minutes <= 0 || $total_questions <= 0) {
        $error = 'Please fill in all required fields correctly.';
    } else {
        // Check if shuffle_questions column exists, if not add it
        $sql_check_column = "SHOW COLUMNS FROM exams LIKE 'shuffle_questions'";
        $column_result = execute_query($mysqli, $sql_check_column);
        
        if ($column_result && $column_result->num_rows === 0) {
            // Add the column if it doesn't exist
            $sql_add_column = "ALTER TABLE exams ADD COLUMN shuffle_questions TINYINT(1) DEFAULT 0 AFTER is_active";
            $mysqli->query($sql_add_column);
        }

        $sql_update = "UPDATE exams 
                       SET target_grade = ?, 
                           exam_title = ?, 
                           exam_description = ?, 
                           duration_minutes = ?, 
                           total_questions = ?, 
                           exam_mode = ?, 
                           is_active = ?,
                           shuffle_questions = ?
                       WHERE exam_id = ?";

        $affected_rows = execute_non_query($mysqli, $sql_update, 'ssiiisiii', [
            $target_grade,
            $exam_title,
            $exam_description,
            $duration_minutes,
            $total_questions,
            $exam_mode,
            $is_active,
            $shuffle_questions,
            $exam_id
        ]);

        if ($affected_rows !== false) {
            $_SESSION['success_message'] = "Exam '{$exam_title}' updated successfully.";
            redirect('admin/exams.php');
        } else {
            $error = 'Error updating exam.';
        }
    }
}

include 'includes/header.php';

if ($error): ?>
    <p class="error"><?php echo $error; ?></p>
<?php endif; ?>

<?php if ($success): ?>
    <p class="success"><?php echo $success; ?></p>
<?php endif; ?>

<form method="POST" action="edit_exam.php?id=<?php echo $exam_id; ?>">
    <div class="form-group">
        <label for="exam_title">Exam Title:</label>
        <input type="text" id="exam_title" name="exam_title"
            value="<?php echo htmlspecialchars($_POST['exam_title'] ?? $exam['exam_title']); ?>" required>
    </div>
    <div class="form-group">
        <label for="target_grade">Target Grade:</label>
        <select id="target_grade" name="target_grade" required>
            <option value="">Select Grade</option>
            <?php foreach ($grades as $grade): ?>
                <option value="<?php echo $grade['grade']; ?>" 
                    <?php echo (($_POST['target_grade'] ?? $exam['target_grade']) === $grade['grade']) ? 'selected' : ''; ?>>
                    <?php echo htmlspecialchars($grade['grade']); ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="exam_mode">Exam Mode:</label>
        <select id="exam_mode" name="exam_mode" required>
            <option value="">Select Mode</option>
            <?php foreach ($exam_modes as $mode): ?>
                <option value="<?php echo $mode; ?>" 
                    <?php echo (($_POST['exam_mode'] ?? $exam['exam_mode']) === $mode) ? 'selected' : ''; ?>>
                    <?php echo $mode; ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="form-group">
        <label for="duration_minutes">Duration (minutes):</label>
        <input type="number" id="duration_minutes" name="duration_minutes" min="1"
            value="<?php echo htmlspecialchars($_POST['duration_minutes'] ?? $exam['duration_minutes']); ?>" required>
    </div>
    <div class="form-group">
        <label for="total_questions">Total Questions:</label>
        <input type="number" id="total_questions" name="total_questions" min="1"
            value="<?php echo htmlspecialchars($_POST['total_questions'] ?? $exam['total_questions']); ?>" required>
    </div>
    <div class="form-group">
        <label for="exam_description">Description:</label>
        <textarea id="exam_description"
            name="exam_description"><?php echo htmlspecialchars($_POST['exam_description'] ?? $exam['exam_description']); ?></textarea>
    </div>
    <div class="form-group">
        <input type="checkbox" id="is_active" name="is_active" value="1" 
            <?php echo (isset($_POST['is_active']) ? 'checked' : ($exam['is_active'] ? 'checked' : '')); ?>>
        <label for="is_active" style="display: inline;">Is Active</label>
    </div>
    <div class="form-group">
        <input type="checkbox" id="shuffle_questions" name="shuffle_questions" value="1" 
            <?php echo (isset($_POST['shuffle_questions']) ? 'checked' : (isset($exam['shuffle_questions']) && $exam['shuffle_questions'] ? 'checked' : '')); ?>>
        <label for="shuffle_questions" style="display: inline;">Shuffle Questions (Randomly pick questions equal to total questions count)</label>
    </div>
    <button type="submit">Update Exam</button>
    <a href="<?php echo BASE_URL; ?>admin/exams.php"><button type="button">Cancel</button></a>
</form>
<?php
include 'includes/footer.php';
?>
