<?php
// edit_grade.php - Admin Edit Grade

require_once '../db.php';
require_admin();

// Set page title for header
$page_title = 'Edit Grade';

$error = '';
$grade_id = (int)($_GET['id'] ?? 0);

// Fetch existing grade data
$sql_select = "SELECT * FROM grades WHERE grade_id = ?";
$result = execute_query($mysqli, $sql_select, 'i', [$grade_id]);
$grade = $result ? $result->fetch_assoc() : null;

if (!$grade) {
    $_SESSION['error_message'] = "Grade not found.";
    redirect('admin/grades.php');
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $grade_name = trim($_POST['grade_name'] ?? '');
    $description = trim($_POST['description'] ?? '');

    if (empty($grade_name)) {
        $error = 'Grade Name is required.';
    } else {
        // Check for duplicate grade name, excluding the current grade
        $sql_check = "SELECT grade_id FROM grades WHERE grade_name = ? AND grade_id != ?";
        $result_check = execute_query($mysqli, $sql_check, 'si', [$grade_name, $grade_id]);

        if ($result_check && $result_check->num_rows > 0) {
            $error = "A grade with the name '{$grade_name}' already exists.";
        } else {
            // Update the grade name in the users and exams tables if it has changed
            if ($grade_name !== $grade['grade_name']) {
                // Update users table
                $sql_update_users = "UPDATE users SET grade = ? WHERE grade = ?";
                execute_non_query($mysqli, $sql_update_users, 'ss', [$grade_name, $grade['grade_name']]);

                // Update exams table
                $sql_update_exams = "UPDATE exams SET target_grade = ? WHERE target_grade = ?";
                execute_non_query($mysqli, $sql_update_exams, 'ss', [$grade_name, $grade['grade_name']]);
            }

            // Update the grades table
            $sql_update = "UPDATE grades SET grade_name = ?, description = ?, updated_at = NOW() WHERE grade_id = ?";
            $affected_rows = execute_non_query($mysqli, $sql_update, 'ssi', [
                $grade_name, 
                $description,
                $grade_id
            ]);

            if ($affected_rows) {
                $_SESSION['success_message'] = "Grade '{$grade_name}' updated successfully.";
                redirect('admin/grades.php');
            } else {
                $error = 'Error updating grade or no changes were made.';
            }
        }
    }
}

// Re-fetch grade data in case of POST error to display current values
$sql_select = "SELECT * FROM grades WHERE grade_id = ?";
$result = execute_query($mysqli, $sql_select, 'i', [$grade_id]);
$grade = $result ? $result->fetch_assoc() : null;

include 'includes/header.php';
?>
        <h2><?php echo $page_title; ?>: <?php echo htmlspecialchars($grade['grade_name']); ?></h2>

        <?php if ($error): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>

        <form method="POST" action="edit_grade.php?id=<?php echo $grade_id; ?>">
            <div class="form-group">
                <label for="grade_name">Grade Name (e.g., RT, JR, SR):</label>
                <input type="text" id="grade_name" name="grade_name" value="<?php echo htmlspecialchars($_POST['grade_name'] ?? $grade['grade_name']); ?>" required maxlength="50">
            </div>
            <div class="form-group">
                <label for="description">Description (Optional):</label>
                <textarea id="description" name="description"><?php echo htmlspecialchars($_POST['description'] ?? $grade['description']); ?></textarea>
            </div>
            <button type="submit">Update Grade</button>
        </form>
<?php
include 'includes/footer.php';
?>
