-- ============================================================================
-- Database Migration Script
-- Purpose: Fix start_time column to prevent auto-update on row changes
-- Date: December 10, 2025
-- ============================================================================

-- This script removes the "ON UPDATE current_timestamp()" clause from the
-- start_time column in the student_exam_sessions table.
--
-- Problem: The start_time was being updated every time any field in the row
-- was modified (e.g., when end_time was set on exam submission).
--
-- Solution: Remove the auto-update behavior so start_time remains fixed
-- at the moment the exam session was created.

USE proctored_exam_app2;

-- Modify the start_time column to remove ON UPDATE current_timestamp()
ALTER TABLE `student_exam_sessions` 
MODIFY COLUMN `start_time` timestamp NOT NULL DEFAULT current_timestamp();

-- Verification query (optional - run after the ALTER to confirm)
-- SHOW CREATE TABLE student_exam_sessions;

-- ============================================================================
-- INSTRUCTIONS FOR USE:
-- ============================================================================
-- 1. Backup your database before running this script:
--    mysqldump -u root -p proctored_exam_app2 > backup_before_fix.sql
--
-- 2. Run this script via command line:
--    mysql -u root -p proctored_exam_app2 < fix_start_time_column.sql
--
-- 3. Or run via phpMyAdmin:
--    - Open phpMyAdmin
--    - Select the proctored_exam_app2 database
--    - Click on the SQL tab
--    - Copy and paste the ALTER TABLE command above
--    - Click "Go"
--
-- 4. Verify the change:
--    SHOW CREATE TABLE student_exam_sessions;
--    
--    The start_time column should now show:
--    `start_time` timestamp NOT NULL DEFAULT current_timestamp()
--    
--    (WITHOUT "ON UPDATE current_timestamp()")
-- ============================================================================
