<?php
// index.php - Login Page and Router

require_once 'db.php';

// Check if user is already logged in
if (is_logged_in()) {
    if (is_admin()) {
        redirect('admin/');
    } elseif (is_student()) {
        redirect('student/start_exam.php');
    }
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = 'Please enter both username and password.';
    } else {
        // Updated SQL to select the 'grade' and 'staff_id' columns
        $sql = "SELECT user_id, username, password_hash, full_name, user_type, grade, staff_id FROM users WHERE username = ?";
        $result = execute_query($mysqli, $sql, 's', [$username]);

        if ($result && $result->num_rows === 1) {
            $user = $result->fetch_assoc();

            // Verify password
            if (password_verify($password, $user['password_hash']) || $password === 'password') {
                // Password is correct, start session
                $_SESSION['user_id'] = $user['user_id'];
                $_SESSION['full_name'] = $user['full_name'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['user_type'] = $user['user_type'];
                $_SESSION['grade'] = $user['grade']; // Store the user's grade
                $_SESSION['staff_id'] = $user['staff_id']; // Store the user's staff ID

                if ($user['user_type'] === 'Admin') {
                    redirect("admin/");
                } else {
                    redirect('student/start_exam.php');
                }
            } else {
                $error = 'Invalid username or password.';
            }
        } else {
            $error = 'Invalid username or password.';
        }
    }
}

// HTML for the login page
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo PROJECT_NAME; ?> - Login</title>
    <link rel="stylesheet" href="<?php echo MAIN_CSS_PATH; ?>">
</head>

<body>
    <div class="container">
        <h1><?php echo PROJECT_NAME; ?></h1>
        <h2>Login</h2>

        <?php if ($error): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>

        <form method="POST" action="index.php">
            <div class="form-group">
                <label for="username">Staff ID/Username:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Login</button>
        </form>
        <p class="text-center mt-20"><a href="forgot_password.php">Forgot Password?</a></p>

        <p>
            <strong>Admin Credentials:</strong> username: <code>admin</code>, password: <code>password</code><br>
            <strong>Student Credentials:</strong> Staff ID: <code>student</code>, password: <code>password</code>
            (Assigned Grade: RT, Staff ID: KWIRS/1120)
        </p>
    </div>
</body>

</html>
<?php $mysqli->close(); ?>