#!/usr/bin/env php
<?php
// process_video_background.php - Background worker for video processing
// This script is called by process_video_background() to run in the background

// Get session_id from command line argument
if ($argc < 2) {
    error_log("Video Processing Background: No session_id provided");
    exit(1);
}

$session_id = (int)$argv[1];

if ($session_id <= 0) {
    error_log("Video Processing Background: Invalid session_id: $session_id");
    exit(1);
}

// Include the video processor and db connection
// db.php is in the parent directory (../)
require_once __DIR__ . '/../db.php';
require_once __DIR__ . '/video_processor.php';

// Process the video
error_log("Video Processing Background: Starting processing for session $session_id");

// The process_video_chunks function uses the PROJECT_ROOT_DIR defined in db.php
$result = process_video_chunks($session_id, $mysqli);

if ($result['success']) {
    error_log("Video Processing Background: Successfully processed session $session_id - " . $result['video_path']);
    exit(0);
} else {
    error_log("Video Processing Background: Failed to process session $session_id - " . $result['message']);
    exit(1);
}
?>
