-- phpMyAdmin SQL Dump
-- version 5.2.0
-- https://www.phpmyadmin.net/
--
-- Host: 127.0.0.1
-- Generation Time: Dec 11, 2025 at 03:08 PM
-- Server version: 10.4.27-MariaDB
-- PHP Version: 8.1.12

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `proctored_exam_app2`
--

-- --------------------------------------------------------

--
-- Table structure for table `exams`
--

CREATE TABLE `exams` (
  `exam_id` int(11) NOT NULL,
  `exam_title` varchar(255) NOT NULL,
  `exam_description` text DEFAULT NULL,
  `duration_minutes` int(11) NOT NULL,
  `total_questions` int(11) NOT NULL,
  `exam_mode` enum('Mixed','MCQ','Theory','Fill-in-the-gaps') NOT NULL,
  `target_grade` varchar(50) DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  `shuffle_questions` tinyint(1) DEFAULT 0 COMMENT 'Enable random question selection (1=Yes, 0=No)',
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exams`
--

INSERT INTO `exams` (`exam_id`, `exam_title`, `exam_description`, `duration_minutes`, `total_questions`, `exam_mode`, `target_grade`, `is_active`, `shuffle_questions`, `created_by`, `created_at`, `updated_at`) VALUES
(1, 'END OF YEAR EXAM RT', '0', 20, 27, 'Mixed', 'RT', 1, 1, 1, '2025-12-10 18:30:38', '2025-12-10 23:14:23');

-- --------------------------------------------------------

--
-- Table structure for table `exam_questions`
--

CREATE TABLE `exam_questions` (
  `question_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `question_type` enum('Mixed','MCQ','Theory','Fill-in-the-gaps') NOT NULL,
  `question_text` text NOT NULL,
  `option_a` varchar(255) DEFAULT NULL,
  `option_b` varchar(255) DEFAULT NULL,
  `option_c` varchar(255) DEFAULT NULL,
  `option_d` varchar(255) DEFAULT NULL,
  `correct_option` enum('A','B','C','D') DEFAULT NULL,
  `correct_answer` text DEFAULT NULL,
  `expected_keywords` text DEFAULT NULL,
  `points` decimal(5,2) NOT NULL DEFAULT 1.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `exam_questions`
--

INSERT INTO `exam_questions` (`question_id`, `exam_id`, `question_type`, `question_text`, `option_a`, `option_b`, `option_c`, `option_d`, `correct_option`, `correct_answer`, `expected_keywords`, `points`, `created_at`, `updated_at`) VALUES
(1, 1, 'MCQ', 'What is the capital of Nigeria?', 'Lagos', 'Abuja', 'Kano', 'Enugu', 'B', '0', 'capital,Nigeria', '3.00', '2025-12-10 19:00:00', '2025-12-10 21:54:18'),
(2, 1, 'MCQ', 'Which planet is known as the Red Planet?', 'Earth', 'Mars', 'Jupiter', 'Saturn', 'B', '0', 'Mars,planet', '2.00', '2025-12-10 19:00:10', '2025-12-10 21:54:18'),
(3, 1, 'MCQ', 'How many days are in a leap year?', '365', '366', '367', '364', 'B', '0', 'leap year', '2.00', '2025-12-10 19:00:20', '2025-12-10 21:54:18'),
(4, 1, 'MCQ', 'Which of these is a programming language?', 'Python', 'Carrot', 'Laptop', 'Orange', 'A', '0', 'Python,programming', '4.00', '2025-12-10 19:00:30', '2025-12-10 21:54:18'),
(5, 1, 'MCQ', 'What color is the sky on a clear day?', 'Blue', 'Red', 'Yellow', 'Green', 'A', '0', 'sky,blue', '1.50', '2025-12-10 19:00:40', '2025-12-10 21:54:18'),
(6, 1, 'MCQ', 'Which animal is known as the King of the Jungle?', 'Tiger', 'Lion', 'Elephant', 'Giraffe', 'B', '0', 'lion,animal', '2.50', '2025-12-10 19:00:50', '2025-12-10 21:54:18'),
(7, 1, 'MCQ', 'What is 2 + 2?', '3', '5', '4', '6', 'C', '0', 'math', '1.00', '2025-12-10 19:01:00', '2025-12-10 21:54:18'),
(8, 1, 'MCQ', 'Which continent is Nigeria located in?', 'Europe', 'Asia', 'Africa', 'America', 'C', '0', 'Nigeria,Africa', '3.00', '2025-12-10 19:01:10', '2025-12-10 21:54:18'),
(9, 1, 'MCQ', 'What device is used to take photos?', 'Radio', 'Camera', 'Speaker', 'Fan', 'B', '0', 'camera,photos', '2.00', '2025-12-10 19:01:20', '2025-12-10 21:54:18'),
(10, 1, 'MCQ', 'Which one is a fruit?', 'Banana', 'Table', 'Car', 'Shoe', 'A', '0', 'fruit', '1.50', '2025-12-10 19:01:30', '2025-12-10 21:54:18'),
(11, 1, 'MCQ', 'What is the boiling point of water?', '50°C', '100°C', '150°C', '80°C', 'B', '0', 'boiling,water', '2.00', '2025-12-10 19:10:00', '2025-12-10 21:54:18'),
(12, 1, 'MCQ', 'Which of these is a web browser?', 'Chrome', 'Excel', 'Photoshop', 'Word', 'A', '0', 'browser,Chrome', '2.50', '2025-12-10 19:10:10', '2025-12-10 21:54:18'),
(13, 1, 'MCQ', 'What is the largest ocean in the world?', 'Atlantic', 'Indian', 'Pacific', 'Arctic', 'C', '0', 'ocean,largest', '3.00', '2025-12-10 19:10:20', '2025-12-10 21:54:18'),
(14, 1, 'MCQ', 'Which gas do plants breathe in?', 'Oxygen', 'Nitrogen', 'Carbon Dioxide', 'Hydrogen', 'C', '0', 'plants,gas', '2.00', '2025-12-10 19:10:30', '2025-12-10 21:54:18'),
(15, 1, 'MCQ', 'What does CPU stand for?', 'Central Processing Unit', 'Control Power Unit', 'Central Power Utility', 'Computer Processing Utility', 'A', '0', 'CPU,computer', '4.00', '2025-12-10 19:10:40', '2025-12-10 21:54:18'),
(16, 1, 'MCQ', 'Which country uses the Yen?', 'China', 'South Korea', 'Japan', 'Thailand', 'C', '0', 'Yen,Japan', '1.50', '2025-12-10 19:10:50', '2025-12-10 21:54:18'),
(17, 1, 'MCQ', 'What is H2O commonly known as?', 'Salt', 'Water', 'Air', 'Sugar', 'B', '0', 'H2O,water', '1.00', '2025-12-10 19:11:00', '2025-12-10 21:54:18'),
(18, 1, 'MCQ', 'Which shape has 4 equal sides?', 'Circle', 'Rectangle', 'Triangle', 'Square', 'D', '0', 'shape,square', '1.50', '2025-12-10 19:11:10', '2025-12-10 21:54:18'),
(19, 1, 'MCQ', 'Which of these is a search engine?', 'Google', 'WhatsApp', 'Facebook', 'Netflix', 'A', '0', 'search engine', '2.50', '2025-12-10 19:11:20', '2025-12-10 21:54:18'),
(20, 1, 'MCQ', 'How many continents are there in the world?', '5', '6', '7', '8', 'C', '0', 'continents', '2.00', '2025-12-10 19:11:30', '2025-12-10 21:54:18'),
(21, 1, 'MCQ', 'What is the opposite of hot?', 'Warm', 'Soft', 'Cold', 'Hard', 'C', '0', 'hot,cold', '1.00', '2025-12-10 19:11:40', '2025-12-10 21:54:18'),
(22, 1, 'MCQ', 'Which instrument has keys and is played with the hands?', 'Drum', 'Violin', 'Piano', 'Flute', 'C', '0', 'instrument,piano', '2.00', '2025-12-10 19:11:50', '2025-12-10 21:54:18'),
(23, 1, 'MCQ', 'How many hours make a day?', '12 hours', '24 hours', '48 hours', '36 hours', 'B', '0', 'day,hours', '1.00', '2025-12-10 19:12:00', '2025-12-10 21:54:18'),
(24, 1, 'MCQ', 'Which metal is used to make coins?', 'Gold', 'Silver', 'Copper', 'Plastic', 'C', '0', 'metal,coins', '2.00', '2025-12-10 19:12:10', '2025-12-10 21:54:18'),
(25, 1, 'MCQ', 'Which organ pumps blood in the human body?', 'Heart', 'Liver', 'Kidney', 'Lungs', 'A', '0', 'heart,blood', '3.00', '2025-12-10 19:12:20', '2025-12-10 21:54:18'),
(26, 1, 'Fill-in-the-gaps', 'Who is Ade?', '', '', '', '', '', 'Boy', '0', '5.00', '2025-12-10 22:33:20', '2025-12-10 22:35:14'),
(27, 1, 'Theory', 'Who are you?', '', '', '', '', '', 'Ade', '0', '5.00', '2025-12-10 23:01:36', '2025-12-10 23:01:52');

-- --------------------------------------------------------

--
-- Table structure for table `exam_video_chunks`
--

CREATE TABLE `exam_video_chunks` (
  `chunk_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `chunk_index` int(11) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  `upload_time` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `grades`
--

CREATE TABLE `grades` (
  `grade_id` int(11) NOT NULL,
  `grade_name` varchar(50) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `grades`
--

INSERT INTO `grades` (`grade_id`, `grade_name`, `description`, `created_at`, `updated_at`) VALUES
(1, 'RT', 'Revenue Trainee', '2025-12-06 12:46:37', '2025-12-10 20:16:21'),
(2, 'RA', 'Revenue Assistant', '2025-12-06 12:46:37', '2025-12-08 18:12:14'),
(3, 'DRO', 'Deputy Revenue Officer', '2025-12-08 17:43:48', '2025-12-08 18:12:45'),
(4, 'RO', 'Revenue Officer', '2025-12-08 18:59:07', '2025-12-08 18:59:07');

-- --------------------------------------------------------

--
-- Table structure for table `student_answers`
--

CREATE TABLE `student_answers` (
  `answer_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `question_id` int(11) NOT NULL,
  `student_answer` text DEFAULT NULL,
  `is_correct` tinyint(1) DEFAULT NULL,
  `score_earned` decimal(5,2) DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `student_exam_sessions`
--

CREATE TABLE `student_exam_sessions` (
  `session_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `exam_id` int(11) NOT NULL,
  `public_session_id` varchar(100) NOT NULL,
  `start_time` timestamp NOT NULL DEFAULT current_timestamp(),
  `end_time` timestamp NULL DEFAULT NULL,
  `is_submitted` tinyint(1) DEFAULT 0,
  `total_score` decimal(5,2) DEFAULT 0.00,
  `proctoring_video_path` varchar(255) DEFAULT NULL,
  `video_upload_complete` tinyint(1) DEFAULT 0,
  `question_order` text DEFAULT NULL COMMENT 'Comma-separated list of question IDs in shuffled order for this session',
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `user_id` int(11) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password_hash` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `full_name` varchar(255) NOT NULL,
  `user_type` enum('Admin','Student') NOT NULL,
  `grade` varchar(50) DEFAULT NULL,
  `staff_id` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`user_id`, `username`, `password_hash`, `email`, `full_name`, `user_type`, `grade`, `staff_id`, `created_at`, `updated_at`) VALUES
(1, 'admin', '$2y$10$92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX', NULL, 'System Administrator', 'Admin', NULL, NULL, '2025-12-06 12:45:35', '2025-12-06 12:45:35'),
(2, 'student', '$2y$10$92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX.92eX', 'm.sg@kw-irs.com', 'Test Student', 'Student', 'RT', 'KWIRS/1120', '2025-12-06 12:45:35', '2025-12-10 18:35:48'),
(3, 'k113', '$2y$10$kfmTgRPLk088vSVQviS6su7lp.yAEOAtrEy.66DuBqN8XcV7u/tlK', 'nophyololade@gmail.com', 'kunle salmon', 'Student', 'DRO', 'k113', '2025-12-08 18:33:28', '2025-12-08 18:33:28'),
(4, 'k115', '$2y$10$OZkVEg2TrlEyIgo2rHenoO7HaqVd9M0X.yfP8EyW6OoRkrCcFEVWC', 'nophyololadffe@gmail.com', 'kunle saln hju', 'Student', 'RO', 'k115', '2025-12-08 18:59:55', '2025-12-08 18:59:55');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `exams`
--
ALTER TABLE `exams`
  ADD PRIMARY KEY (`exam_id`),
  ADD KEY `created_by` (`created_by`),
  ADD KEY `idx_exams_target_grade` (`target_grade`);

--
-- Indexes for table `exam_questions`
--
ALTER TABLE `exam_questions`
  ADD PRIMARY KEY (`question_id`),
  ADD KEY `idx_questions_exam` (`exam_id`);

--
-- Indexes for table `exam_video_chunks`
--
ALTER TABLE `exam_video_chunks`
  ADD PRIMARY KEY (`chunk_id`),
  ADD UNIQUE KEY `unique_chunk` (`session_id`,`chunk_index`),
  ADD KEY `idx_chunks_session_index` (`session_id`,`chunk_index`);

--
-- Indexes for table `grades`
--
ALTER TABLE `grades`
  ADD PRIMARY KEY (`grade_id`),
  ADD UNIQUE KEY `grade_name` (`grade_name`);

--
-- Indexes for table `student_answers`
--
ALTER TABLE `student_answers`
  ADD PRIMARY KEY (`answer_id`),
  ADD UNIQUE KEY `session_question_unique` (`session_id`,`question_id`);

--
-- Indexes for table `student_exam_sessions`
--
ALTER TABLE `student_exam_sessions`
  ADD PRIMARY KEY (`session_id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`user_id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `exams`
--
ALTER TABLE `exams`
  MODIFY `exam_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- AUTO_INCREMENT for table `exam_questions`
--
ALTER TABLE `exam_questions`
  MODIFY `question_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT for table `exam_video_chunks`
--
ALTER TABLE `exam_video_chunks`
  MODIFY `chunk_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `grades`
--
ALTER TABLE `grades`
  MODIFY `grade_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `student_answers`
--
ALTER TABLE `student_answers`
  MODIFY `answer_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `student_exam_sessions`
--
ALTER TABLE `student_exam_sessions`
  MODIFY `session_id` int(11) NOT NULL AUTO_INCREMENT;

--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `user_id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
