<?php
// exam_submitted.php - Instant redirect page after submission

require_once '../db.php';
require_student();

$session_id = (int)($_GET['session_id'] ?? 0);

// Basic check to ensure a session ID is present
if ($session_id === 0) {
    redirect('start_exam.php');
}

// Fetch session details to display
$sql = "SELECT E.exam_title, S.start_time, S.total_score, S.is_submitted
        FROM student_exam_sessions S
        JOIN exams E ON S.exam_id = E.exam_id
        WHERE S.session_id = ? AND S.student_id = ?";
$result = execute_query($mysqli, $sql, 'ii', [$session_id, get_current_user_id()]);

if (!$result || $result->num_rows === 0) {
    redirect('start_exam.php');
}

$session_data = $result->fetch_assoc();

// Ensure the exam was actually submitted
if (!$session_data['is_submitted']) {
    $_SESSION['error_message'] = "The exam has not been submitted yet.";
    redirect('student/take_exam.php?session_id=' . $session_id);
}

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Submitted - <?php echo PROJECT_NAME; ?></title>
    <link rel="stylesheet" href="<?php echo MAIN_CSS_PATH; ?>">
</head>
<body>
    <div class="container">
        <h1>Exam Submitted Successfully!</h1>
        <p class="success">Your answers for the exam "<strong><?php echo htmlspecialchars($session_data['exam_title']); ?></strong>" have been saved instantly.</p>
        
        <h2>Your Score: <span style="color: green;"><?php echo htmlspecialchars($session_data['total_score']); ?>%</span></h2>
        
	        <p><strong>Username:</strong> <?php echo htmlspecialchars(get_current_username()); ?></p>
        <p><strong>Start Time:</strong> <?php echo date('Y-m-d H:i:s', strtotime($session_data['start_time'])); ?></p>
        
        <p>You can now safely close this window.</p>
        
        <div class="mt-20">
            <a href="<?php echo BASE_URL; ?>student/start_exam.php"><button>Go Back to Exam List</button></a>
        </div>
        
        <p class="text-center mt-20">
            <small>The proctoring video upload is continuing in the background and will be finalized shortly.</small>
        </p>
    </div>
</body>
</html>
<?php $mysqli->close(); ?>
